/*
 * Decompiled with CFR 0.152.
 */
package ru.pinkgoosik.cosmetica.util;

public class ColorUtil {
    private static final float[] FLOAT_BUFFER = new float[4];
    private static final int ALPHA = -16777216;

    public static int color(int r, int g, int b) {
        return 0xFF000000 | r << 16 | g << 8 | b;
    }

    public static int color(String hex) {
        int r = Integer.parseInt(hex.substring(0, 2), 16);
        int g = Integer.parseInt(hex.substring(2, 4), 16);
        int b = Integer.parseInt(hex.substring(4, 6), 16);
        return ColorUtil.color(r, g, b);
    }

    public static float[] toFloatArray(int color) {
        ColorUtil.FLOAT_BUFFER[0] = (float)(color >> 16 & 0xFF) / 255.0f;
        ColorUtil.FLOAT_BUFFER[1] = (float)(color >> 8 & 0xFF) / 255.0f;
        ColorUtil.FLOAT_BUFFER[2] = (float)(color & 0xFF) / 255.0f;
        ColorUtil.FLOAT_BUFFER[3] = (float)(color >> 24 & 0xFF) / 255.0f;
        return FLOAT_BUFFER;
    }
}

